package shutdown

import (
	"net/http"

	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/travel/avia/shared_flights/lib/go/logger"
)

func NewService() *Service {
	return &Service{}
}

type Service struct {
	shutdown bool
}

func (s *Service) GetRoute() string {
	return "/shutdown"
}

func (s *Service) ServeHTTP(writer http.ResponseWriter, r *http.Request) {
	if r.Method != http.MethodPost {
		s.shutdownResponse(writer, http.StatusMethodNotAllowed, "Use POST method")
		return
	}
	s.stop()
	s.shutdownResponse(writer, http.StatusOK, "OK")
}

func (s *Service) shutdownResponse(writer http.ResponseWriter, code int, reason string) {
	writer.WriteHeader(code)
	if _, err := writer.Write([]byte(reason)); err != nil {
		logger.Logger().Error("Shutdown failed", log.Error(err))
	}
}

func (s *Service) stop() {
	s.shutdown = true
}

func (s *Service) IsStopped() bool {
	return s.shutdown
}
