package pkg

import (
	"time"
)

type AuroraMessage []AuroraAirport

type AuroraAirport struct {
	Airport   string         `json:"airport"`
	Direction string         `json:"type"`
	Flights   []AuroraFlight `json:"flights"`
}

type AuroraFlight struct {
	Airline          string   `json:"airline_code"`
	BaggageCarousels string   `json:"baggage_claim"`
	CheckInDesks     string   `json:"check_in_desks"`
	Codeshares       []string `json:"codeshare"`
	Date             string   `json:"date"`
	Destination      string   `json:"destination"`
	FlightNumber     string   `json:"flight_number"`
	Status           string   `json:"status"`
	Terminal         string   `json:"terminal"`
	Gate             string   `json:"gate"`
	Gates            string   `json:"gates"`
	TimeActual       string   `json:"time_actual"`
	TimeScheduled    string   `json:"time_scheduled"`
}

type AuroraMessageLog struct {
	Unixtime         int64       `json:"unixtime"`
	Airport          string      `json:"airport"`
	BaggageCarousels string      `json:"baggage_carousels"`
	CheckinDesks     string      `json:"check_in_desks"`
	Direction        string      `json:"type"`
	Airline          string      `json:"airline_code"`
	Codeshares       interface{} `json:"codeshares"`
	Date             string      `json:"date"`
	Destination      string      `json:"destination"`
	FlightNumber     string      `json:"flight_number"`
	Status           string      `json:"status"`
	Terminal         string      `json:"terminal"`
	TimeActual       string      `json:"time_actual"`
	TimeScheduled    string      `json:"time_scheduled"`
	Result           string      `json:"result"`
}

func (f *AuroraFlight) GetLog(airport string, direction string, result string) AuroraMessageLog {
	return AuroraMessageLog{
		Unixtime:         time.Now().Unix(),
		Airport:          airport,
		BaggageCarousels: f.BaggageCarousels,
		CheckinDesks:     f.CheckInDesks,
		Direction:        direction,
		Airline:          f.Airline,
		Codeshares:       f.Codeshares,
		Date:             f.Date,
		Destination:      f.Destination,
		FlightNumber:     f.FlightNumber,
		Status:           f.Status,
		Terminal:         f.Terminal,
		TimeActual:       f.TimeActual,
		TimeScheduled:    f.TimeScheduled,
		Result:           result,
	}
}

func (f *AuroraFlight) GetGate() string {
	if f.Gate != "" {
		return f.Gate
	}

	return f.Gates
}
