package pkg

import (
	"net/http"

	"a.yandex-team.ru/library/go/core/xerrors"
)

var (
	NoSuchPipelineError = xerrors.NewSentinel("no such pipeline")
	PipelineIsNilError  = xerrors.NewSentinel("pipeline is nil")
	TimeoutError        = xerrors.NewSentinel("timeout error")
	CollectorIsNilError = xerrors.NewSentinel("collector is nil")
	DeliveryIsNilError  = xerrors.NewSentinel("delivery is nil")
	DecoderIsNilError   = xerrors.NewSentinel("decoder is nil")
)

type ErrorWithHTTPCode interface {
	error
	HTTPCode() int
}

type basicErrorWithHTTPCode struct {
	error
	int
}

func (b basicErrorWithHTTPCode) HTTPCode() int {
	return b.int
}

func NewErrorWithHTTPCode(description string, err error, code int) error {
	return basicErrorWithHTTPCode{xerrors.Errorf("%s: %w", description, err), code}
}

func NewValidationError(err error) error {
	return NewErrorWithHTTPCode("validation error", err, http.StatusBadRequest)
}

func NewDecodingError(err error) error {
	return NewErrorWithHTTPCode("decoding error", err, http.StatusBadRequest)
}

func NewNormalizationError(err error) error {
	return NewErrorWithHTTPCode("decoding error", err, http.StatusBadRequest)
}
