package pkg

import "strings"

type OAGMessage struct {
	FlightIdentifier OAGFlightIdentifier `json:"FlightIdentifier"`
	Alert            OAGAlert            `json:"Alert"`
	FlightData       OAGFlightData       `json:"FlightData"`
	FlightChangeData OAGFlightChangeData `json:"FlightChangeData"`
	AlertIdentifier  string              `json:"AlertIdentifier"`
}

type OAGFlightIdentifier struct {
	AirlineCode          string `json:"AirlineCode"`
	FlightNumber         string `json:"FlightNumber"`
	DepartureAirportCode string `json:"DepartureAirportCode"`
	SchedDepartureLocal  string `json:"SchedDepartureLocal"`
}

type OAGAlert struct {
	Type       string `json:"Type"`
	SubType    string `json:"SubType"`
	Text       string `json:"Text"`
	Reinstated bool   `json:"Reinstated"`
}

type OAGFlightData struct {
	FvFlightID                    string         `json:"FvFlightId"`
	ProcessingTimeUtc             string         `json:"ProcessingTimeUtc"`
	AirlineCode                   string         `json:"AirlineCode"`
	FlightNumber                  string         `json:"FlightNumber"`
	DepartureAirportCode          string         `json:"SchedDepartureAirportCode"`
	ArrivalAirportCode            string         `json:"SchedArrivalAirportCode"`
	Status                        string         `json:"Status"`
	ScheduleStatus                string         `json:"ScheduleStatus"`
	DiversionStatus               string         `json:"DiversionStatus"`
	OperatingAirlineCode          string         `json:"OperatingAirlineCode"`
	OperatingFlightNumber         string         `json:"OperatingFlightNumber"`
	SchedDepartureLocal           string         `json:"SchedDepartureLocal"`
	SchedArrivalLocal             string         `json:"SchedArrivalLocal"`
	SchedDepartureUtc             string         `json:"SchedDepartureUtc"`
	SchedArrivalUtc               string         `json:"SchedArrivalUtc"`
	LatestDeparture               LatestFlight   `json:"LatestDeparture"`
	LatestArrival                 LatestFlight   `json:"LatestArrival"`
	DepartureTerminal             string         `json:"DepartureTerminal"`
	DepartureGate                 string         `json:"DepartureGate"`
	ArrivalTerminal               string         `json:"ArrivalTerminal"`
	ArrivalGate                   string         `json:"ArrivalGate"`
	Baggage                       string         `json:"Baggage"`
	ServiceType                   string         `json:"ServiceType"`
	AircraftType                  string         `json:"AircraftType"`
	OptionalEquipment             string         `json:"OptionalEquipment"`
	WeightClass                   string         `json:"WeightClass"`
	AlternateDepartureAirportCode string         `json:"AlternateDepartureAirportCode"`
	AlternateArrivalAirportCode   string         `json:"AlternateArrivalAirportCode"`
	DepAirportCountryID           string         `json:"DepAirportCountryId"`
	ArrAirportCountryID           string         `json:"ArrAirportCountryId"`
	LegSequenceNumber             int            `json:"LegSequenceNumber"`
	RecoveryExists                bool           `json:"RecoveryExists"`
	TailNumber                    string         `json:"TailNumber"`
	Unscheduled                   bool           `json:"Unscheduled"`
	RecoveryFlight                *OAGFlightData `json:"RecoveryFlight"`
}

type LatestFlight struct {
	Accuracy      string `json:"Accuracy"`
	DateTimeUtc   string `json:"DateTimeUtc"`
	DateTimeLocal string `json:"DateTimeLocal"`
	DateTimeType  string `json:"DateTimeType"`
	SourceType    string `json:"SourceType"`
}

type OAGFlightChangeData struct {
	HasAnyChanges              bool   `json:"HasAnyChanges"`
	StatusChanged              bool   `json:"StatusChanged"`
	PreviousStatus             string `json:"PreviousStatus"`
	DepartureTimeChanged       bool   `json:"DepartureTimeChanged"`
	PreviousDepartureTimeLocal string `json:"PreviousDepartureTimeLocal"`
	PreviousDepartureTimeUtc   string `json:"PreviousDepartureTimeUtc"`
	ArrivalTimeChanged         bool   `json:"ArrivalTimeChanged"`
	PreviousArrivalTimeLocal   string `json:"PreviousArrivalTimeLocal"`
	PreviousArrivalTimeUtc     string `json:"PreviousArrivalTimeUtc"`
	DepartureTerminalChanged   bool   `json:"DepartureTerminalChanged"`
	PreviousDepartureTerminal  string `json:"PreviousDepartureTerminal"`
	DepartureGateChanged       bool   `json:"DepartureGateChanged"`
	PreviousDepartureGate      string `json:"PreviousDepartureGate"`
	ArrivalTerminalChanged     bool   `json:"ArrivalTerminalChanged"`
	PreviousArrivalTerminal    string `json:"PreviousArrivalTerminal"`
	ArrivalGateChanged         bool   `json:"ArrivalGateChanged"`
	PreviousArrivalGate        string `json:"PreviousArrivalGate"`
	BaggageChanged             bool   `json:"BaggageChanged"`
	PreviousBaggage            string `json:"PreviousBaggage"`
	IsNewToFlightWindow        bool   `json:"IsNewToFlightWindow"`
	OtherChanged               bool   `json:"OtherChanged"`
	DiversionStatusChanged     bool   `json:"DiversionStatusChanged"`
	PreviousDiversionStatus    string `json:"PreviousDiversionStatus"`
}

func (d OAGFlightData) GetDepartureDate() string {
	return strings.Split(d.SchedDepartureLocal, "T")[0]
}

func (d OAGFlightData) GetArrivalDate() string {
	return strings.Split(d.SchedArrivalLocal, "T")[0]
}

func (d OAGFlightData) IsDiverted() bool {
	return d.DiversionStatus == "Diverted"
}
