package pkg

type VariFlightStatus struct {
	FlightNumber               string                   `json:"FlightNo"`
	DepartureAirportCode       string                   `json:"FlightDepcode"`
	ArrivalAirportCode         string                   `json:"FlightArrcode"`
	ScheduledDepartureDateTime string                   `json:"FlightDeptimePlanDate"`
	ScheduledArrivalDateTime   string                   `json:"FlightArrtimePlanDate"`
	EstimatedDepartureDateTime string                   `json:"FlightDeptimeReadyDate"`
	EstimatedArrivalDateTime   string                   `json:"FlightArrtimeReadyDate"`
	ActualDepartureDateTime    string                   `json:"FlightDeptimeDate"`
	ActualArrivalDateTime      string                   `json:"FlightArrtimeDate"`
	CheckInDesks               string                   `json:"CheckinTable"`
	BoardGate                  string                   `json:"BoardGate"`
	BaggageCarousels           string                   `json:"BaggageID"`
	Status                     string                   `json:"FlightState"`
	BoardStatus                string                   `json:"BoardState"`
	DepartureTerminal          string                   `json:"FlightHTerminal"`
	ArrivalTerminal            string                   `json:"FlightTerminal"`
	DivertedInfos              []VariFlightDivertedInfo `json:"alternate_info"`
}

type VariFlightDivertedInfo struct {
	Status                     string `json:"AlternateStatus"`
	DepartureAirportCode       string `json:"AlternateDepAirport"`
	ArrivalAirportCode         string `json:"AlternateArrAirport"`
	ScheduledDepartureDateTime string `json:"AlternateDeptimePlan"`
	ScheduledArrivalDateTime   string `json:"AlternateArrtimePlan"`
	ActualDepartureDateTime    string `json:"AlternateDeptime"`
	ActualArrivalDateTime      string `json:"AlternateArrtime"`
}

func (s VariFlightStatus) ScheduledDepartureDate() string {
	return s.ScheduledDepartureDateTime[:10]
}

func (s VariFlightStatus) ScheduledArrivalDate() string {
	return s.ScheduledArrivalDateTime[:10]
}

func (s VariFlightStatus) ActualDepartureTime() string {
	if len(s.ActualDepartureDateTime) > 0 {
		return s.ActualDepartureDateTime
	}
	if len(s.EstimatedDepartureDateTime) > 0 {
		return s.EstimatedDepartureDateTime
	}

	return s.ScheduledDepartureDateTime
}

func (s VariFlightStatus) ActualArrivalTime() string {
	if len(s.ActualArrivalDateTime) > 0 {
		return s.ActualArrivalDateTime
	}
	if len(s.EstimatedArrivalDateTime) > 0 {
		return s.EstimatedArrivalDateTime
	}

	return s.ScheduledArrivalDateTime
}

func (s VariFlightStatus) IsDiverted() bool {
	return s.Status == "diversion" || s.Status == "diverted flight arrival" || s.Status == "diverted flight departure"
}
