# coding=utf-8
from __future__ import unicode_literals

import logging
import sys
from argparse import ArgumentParser
from datetime import datetime, timedelta

from travel.avia.flight_status_registrar.flight_stats.lib.pipeline import flight_stats_pipeline


def main():
    logging.basicConfig(
        level=logging.INFO,
        stream=sys.stdout,
    )

    parser = ArgumentParser()

    parser.add_argument('--app-id', default='32c60eaa')
    parser.add_argument('--app-key', required=True)
    parser.add_argument('--api-url', default='https://api.flightstats.com/flex')

    parser.add_argument('--yt-proxy', default='hahn')
    parser.add_argument('--yt-token', required=True)
    parser.add_argument('--popular-flights-table',
                        default='//home/avia/reports/wizard/popular_flights_with_competitors')

    parser.add_argument('--avia-backend-url', default='http://backend.testing.avia.yandex.net')
    parser.add_argument('--shared-flights-api-url', default='http://shared-flights.testing.avia.yandex.net')

    parser.add_argument('--flights-per-request', type=int, default=100)

    parser.add_argument('--departure-date')
    parser.add_argument('--flights-limit', type=int, default=100)
    parser.add_argument('--create-alert', action='store_true', default=False)
    parser.add_argument('--http-connection-timeout', type=int, default=60)
    parser.add_argument('--http-read-timeout', type=int, default=60)
    parser.add_argument('--environment', default='testing')
    parser.add_argument('--alert-handler', default='https://avia.yandex.ru/flight-stats/alert')

    arguments = parser.parse_args()

    if not arguments.departure_date:
        departure_date = (datetime.today() + timedelta(days=1)).date()
    else:
        departure_date = datetime.strptime(arguments.departure_date, '%Y-%m-%d').date()

    flight_stats_pipeline(
        api_url=arguments.api_url,
        app_id=arguments.app_id,
        app_key=arguments.app_key,
        yt_proxy=arguments.yt_proxy,
        yt_token=arguments.yt_token,
        popular_flights_table=arguments.popular_flights_table,
        flights_per_request=arguments.flights_per_request,
        avia_backend_url=arguments.avia_backend_url,
        shared_flights_api_url=arguments.shared_flights_api_url,
        departure_date=departure_date,
        flights_limit=int(arguments.flights_limit),
        http_connection_timeout=int(arguments.http_connection_timeout),
        http_read_timeout=int(arguments.http_read_timeout),
        environment=arguments.environment,
        alert_handler=arguments.alert_handler,
        create_alert=arguments.create_alert,
    )


if __name__ == '__main__':
    main()
