import logging

from travel.avia.flight_status_registrar.flight_stats.lib.registrar import FlightStatsRegistrar
from travel.avia.flight_status_registrar.lib.avia_tablo import AviaTabloFetcher
from travel.avia.flight_status_registrar.lib.flights_fetcher import PopularFlightsFetcher
from travel.avia.flight_status_registrar.lib.pipeline import RegistrarError
from travel.avia.library.python.lib_yt.client import configured_client
from travel.avia.library.python.shared_flights_client.client import SharedFlightsClient

from travel.avia.flight_status_registrar.flight_stats.lib.alerts import get_created_alerts

logger = logging.getLogger(__name__)


def flight_stats_pipeline(
    api_url,
    app_id,
    app_key,
    yt_proxy,
    yt_token,
    popular_flights_table,
    departure_date,
    flights_per_request,
    avia_backend_url,
    http_connection_timeout,
    http_read_timeout,
    create_alert,
    environment,
    alert_handler,
    shared_flights_api_url,
    flights_limit=100,
    task=None,
    created_alerts_resource_type=None,
):
    created_alerts = set()
    if created_alerts_resource_type:
        created_alerts = get_created_alerts(created_alerts_resource_type, departure_date, environment)
    run_pipeline(
        registrar=FlightStatsRegistrar(
            api_url,
            app_id,
            app_key,
            shared_flights_api_url,
            http_connection_timeout,
            http_read_timeout,
            create_alert,
            created_alerts,
            environment,
            alert_handler,
            task,
            created_alerts_resource_type,
        ),
        flights_fetcher=PopularFlightsFetcher(
            yt_client=configured_client(yt_proxy, yt_token),
            flights_fetcher=SharedFlightsClient(shared_flights_api_url),
            avia_tablo_fetcher=AviaTabloFetcher(avia_backend_url),
            popular_flights_yt_table=popular_flights_table,
            flights_per_request=flights_per_request,
        ),
        departure_date=departure_date,
        flights_limit=int(flights_limit),
    )


def run_pipeline(registrar, flights_fetcher, departure_date, flights_limit):
    registered_flights = []
    for flight in flights_fetcher.get_flights(departure_date):
        try:
            if registrar.register_flight(flight):
                registered_flights.append(flight)
            if len(registered_flights) == flights_limit:
                break
        except RegistrarError as e:
            logger.warning('Skip flight "%s %s": %s', flight.airline_code, flight.number, e)

    registrar.save_created_alerts(departure_date)

    logger.info(
        'All flights have been registered. Here\'s a list:\n %s',
        registered_flights,
    )
