import logging

import requests


class AviaTabloFetcher:
    def __init__(self, avia_backend_url):
        self.avia_backend_url = avia_backend_url

    def get_airports_tablo_sources(self):
        url = '{}/rest/airport-tablo-source'.format(self.avia_backend_url)

        logging.info('Fetching airport tablo source from: %s', url)
        response = requests.get(url)
        response.raise_for_status()

        data = response.json()

        if data['status'] != 'ok':
            raise RuntimeError('Error requesting avia-backend: {}'.format(data.error))
        return {
            d['airport_id']: d['source'] for d in data['data']
        }
