import logging

from travel.avia.flight_status_registrar.lib.registrar import RegistrarError

logger = logging.getLogger(__name__)


def run_pipeline(registrar, flights_fetcher, departure_date, flights_limit):
    registered_flights = []
    for flight in flights_fetcher.get_flights(departure_date):
        try:
            registrar.register_flight(flight)
            registered_flights.append(flight)
            if len(registered_flights) == flights_limit:
                break
        except RegistrarError as e:
            logger.warning('Skip flight "%s %s": %s', flight.airline_code, flight.number, e)

    logger.info(
        'All flights have been registered. Here\'s a list:\n %s',
        registered_flights,
    )
