# coding=utf-8
from __future__ import unicode_literals

import logging
import sys
from argparse import ArgumentParser
from datetime import datetime, timedelta

from travel.avia.flight_status_registrar.oag.lib.pipeline import oag_pipeline


def main():
    logging.basicConfig(
        level=logging.INFO,
        stream=sys.stdout,
    )

    parser = ArgumentParser()

    parser.add_argument('--oag-app-id', required=True)
    parser.add_argument('--oag-auth-key', required=True)

    parser.add_argument('--yt-proxy', default='hahn')
    parser.add_argument('--yt-token', required=True)
    parser.add_argument('--popular-flights-table',
                        default='//home/avia/reports/wizard/popular_flights_with_competitors')

    parser.add_argument('--shared-flights-url', default='http://shared-flights.testing.avia.yandex.net')
    parser.add_argument('--avia-backend-url', default='http://backend.testing.avia.yandex.net')

    parser.add_argument('--flights-per-request', type=int, default=100)

    parser.add_argument('--departure-date', required=False)
    parser.add_argument('--flights-limit', required=False, default=100)

    arguments = parser.parse_args()

    if not arguments.departure_date:
        departure_date = (datetime.today() + timedelta(days=1)).date()
    else:
        departure_date = datetime.strptime(arguments.departure_date, '%Y-%m-%d').date()

    oag_pipeline(
        app_id=arguments.oag_app_id,
        auth_key=arguments.oag_auth_key,

        yt_proxy=arguments.yt_proxy,
        yt_token=arguments.yt_token,
        popular_flights_table=arguments.popular_flights_table,

        shared_flights_url=arguments.shared_flights_url,
        flights_per_request=arguments.flights_per_request,
        avia_backend_url=arguments.avia_backend_url,

        departure_date=departure_date,
        flights_limit=int(arguments.flights_limit),
    )


if __name__ == '__main__':
    main()
