from travel.avia.library.python.lib_yt.client import configured_client
from travel.avia.library.python.shared_flights_client.client import SharedFlightsClient

from travel.avia.flight_status_registrar.lib.avia_tablo import AviaTabloFetcher
from travel.avia.flight_status_registrar.lib.flights_fetcher import PopularFlightsFetcher
from travel.avia.flight_status_registrar.lib.pipeline import run_pipeline
from travel.avia.flight_status_registrar.oag.lib.registrar import OAGRegistrar


def oag_pipeline(
    app_id,
    auth_key,

    yt_proxy,
    yt_token,
    popular_flights_table,

    departure_date,

    shared_flights_url,
    flights_per_request,
    avia_backend_url,

    flights_limit=100,
):
    run_pipeline(
        registrar=OAGRegistrar(app_id, auth_key),
        flights_fetcher=PopularFlightsFetcher(
            yt_client=configured_client(yt_proxy, yt_token),
            flights_fetcher=SharedFlightsClient(shared_flights_url),
            avia_tablo_fetcher=AviaTabloFetcher(avia_backend_url),
            popular_flights_yt_table=popular_flights_table,
            flights_per_request=flights_per_request,
        ),
        departure_date=departure_date,
        flights_limit=int(flights_limit),
    )
