package dicts

import (
	"strings"

	"github.com/iancoleman/strcase"
)

type ResourceType string

const (
	AviaCompany         ResourceType = "TRAVEL_DICT_AVIA_AVIA_COMPANY_PROD"
	CityMajority        ResourceType = "TRAVEL_DICT_AVIA_CITY_MAJORITY_PROD"
	CodeSystem          ResourceType = "TRAVEL_DICT_AVIA_CODE_SYSTEM_PROD"
	Company             ResourceType = "TRAVEL_DICT_AVIA_COMPANY_PROD"
	CompanyTariff       ResourceType = "TRAVEL_DICT_AVIA_COMPANY_TARIFF_PROD"
	Country             ResourceType = "TRAVEL_DICT_AVIA_COUNTRY_PROD"
	Currency            ResourceType = "TRAVEL_DICT_AVIA_CURRENCY_PROD"
	IataCorrection      ResourceType = "TRAVEL_DICT_AVIA_IATA_CORRECTION_PROD"
	PointSynonym        ResourceType = "TRAVEL_DICT_AVIA_POINT_SYNONYM"
	Region              ResourceType = "TRAVEL_DICT_AVIA_REGION_PROD"
	SettlementBigImage  ResourceType = "TRAVEL_DICT_AVIA_SETTLEMENT_BIG_IMAGE_PROD"
	Settlements         ResourceType = "TRAVEL_DICT_AVIA_SETTLEMENTS_PROD"
	Station             ResourceType = "TRAVEL_DICT_AVIA_STATION_PROD"
	StationToSettlement ResourceType = "TRAVEL_DICT_AVIA_STATION_TO_SETTLEMENT_PROD"
	StationCode         ResourceType = "TRAVEL_DICT_AVIA_STATION_CODE_PROD"
	TranslatedTitle     ResourceType = "TRAVEL_DICT_AVIA_TRANSLATED_TITLE_PROD"

	DirectionNational    ResourceType = "AVIA_WIZARD_DIRECTION_NATIONAL"
	MinPrice             ResourceType = "AVIA_WIZARD_MIN_PRICE"
	RouteCount           ResourceType = "AVIA_WIZARD_ROUTE_COUNT"
	SettlementPopularity ResourceType = "AVIA_WIZARD_SETTLEMENT_NATIONAL"

	RaspAll         ResourceType = "TRAVEL_RASP_COMMON_DICTS_BUNDLE"
	RaspSettlements ResourceType = "TRAVEL_DICT_RASP_SETTLEMENT_PROD"
	RaspStation     ResourceType = "TRAVEL_DICT_RASP_STATION_PROD"
)

func (resourceType ResourceType) ToResourceName() string {
	type_ := string(resourceType)
	type_ = strings.TrimPrefix(type_, "TRAVEL_DICT_")
	type_ = strings.TrimPrefix(type_, "AVIA_")
	type_ = strings.TrimSuffix(type_, "PROD")
	splitted := strings.Split(string(type_), "_")
	name := strings.Join(splitted, " ")
	name = strings.ToLower(name)
	return strcase.ToCamel(name)
}

type ResourceInfo struct {
	type_ ResourceType
	name  string
}

func NewResourceInfo(type_ ResourceType) *ResourceInfo {
	return &ResourceInfo{type_: type_, name: type_.ToResourceName()}
}

func (resourceInfo *ResourceInfo) GetName() string {
	return resourceInfo.name
}
func (resourceInfo *ResourceInfo) GetResourceType() ResourceType {
	return resourceInfo.type_
}
