package handlers

import (
	"a.yandex-team.ru/library/go/core/metrics/solomon"
	"a.yandex-team.ru/library/go/yandex/solomon/reporters/puller/httppuller"
	"fmt"
	"net/http"
)

type MetricsHandler struct {
	name    string
	handler func(http.ResponseWriter, *http.Request)
}

func (h *MetricsHandler) ServeHTTP(writer http.ResponseWriter, request *http.Request) {
	h.handler(writer, request)
}
func (h *MetricsHandler) GetRoute() string {
	return fmt.Sprintf("/metrics/%s/", h.name)
}
func NewMetricsHandler(name string, registry *solomon.Registry) *MetricsHandler {
	metricsHandler := httppuller.NewHandler(registry)
	return &MetricsHandler{handler: metricsHandler.ServeHTTP, name: name}
}
