package handlers

import (
	"a.yandex-team.ru/library/go/core/metrics/solomon"
	"a.yandex-team.ru/travel/avia/library/go/metrics"
	"time"
)

func NewPerfMetricsHandler(metricsRegistryPrefix string, refreshInterval time.Duration) *MetricsHandler {
	perfMetricsRegistry := solomon.NewRegistry(solomon.NewRegistryOpts())
	perfMetrics := metrics.NewPerfMetrics(perfMetricsRegistry.WithPrefix(metricsRegistryPrefix))
	go func() {
		for range time.Tick(refreshInterval) {
			perfMetrics.UpdateCurrentState()
		}
	}()
	return NewMetricsHandler("perf", perfMetricsRegistry)
}
