package logging

import (
	"a.yandex-team.ru/library/go/core/log"
)

type LogFormat string

const (
	Text LogFormat = "text"
	JSON LogFormat = "json"
)

type FileLoggingConfig struct {
	FilePath  string
	LogFormat LogFormat
}

type StdoutLoggingConfig struct {
}

type SentryLoggingConfig struct {
	DSN string
}

type Config struct {
	Level               log.Level
	StdoutLoggingConfig *StdoutLoggingConfig
	FileLoggingConfig   *FileLoggingConfig
	SentryLoggingConfig *SentryLoggingConfig
}

func (config *Config) needLogToFile() bool {
	return config.FileLoggingConfig != nil
}

func (config *Config) needLogToStdout() bool {
	return config.StdoutLoggingConfig != nil
}

func (config *Config) needLogToSentry() bool {
	return config.SentryLoggingConfig != nil
}
