package metrics

import (
	"a.yandex-team.ru/library/go/core/metrics/solomon"
	"strings"
)

func NewAppMetricsRegistry(prefix string) *solomon.Registry {
	if prefix == "" {
		prefix = "app"
	} else {
		prefix = strings.Join([]string{"app", prefix}, ".")
	}
	httpMetricsRegistry := solomon.NewRegistry(solomon.NewRegistryOpts().SetPrefix(prefix))
	httpMetricsRegistry.Gauge("alive").Set(1)
	return httpMetricsRegistry
}
