package probes

import (
	"net/http"

	"github.com/go-chi/chi/v5"

	httpserver "a.yandex-team.ru/travel/library/go/httputil/server"
)

type chiHandler struct {
	state  *State
	config *HTTPConfig
}

func ChiBind(config *HTTPConfig, router *chi.Mux, state *State) {
	handler := chiHandler{state: state, config: config}
	router.Get(config.ReadinessRoute, handler.readinessHandler)
	router.Post(config.ShutdownRoute, handler.shutdownHandler)
}

func GetChiRouteBuilders(config *HTTPConfig, state *State) []httpserver.RouteBuilder {
	handler := chiHandler{state: state, config: config}
	return []httpserver.RouteBuilder{
		func(r chi.Router) {
			r.Get(config.ReadinessRoute, handler.readinessHandler)
		},
		func(r chi.Router) {
			r.Post(config.ShutdownRoute, handler.shutdownHandler)
		},
	}
}

func (h chiHandler) readinessHandler(w http.ResponseWriter, _ *http.Request) {
	var status = http.StatusOK
	var response = readinessOkResponse

	if err := h.state.Ready(); err != nil {
		status = http.StatusGone
		response = err.Error()
	}

	w.WriteHeader(status)
	_, _ = w.Write([]byte(response))
}

func (h chiHandler) shutdownHandler(w http.ResponseWriter, r *http.Request) {
	h.state.Stop(parseDelay(r.FormValue("delay"), h.config.ShutdownDelay))
	w.WriteHeader(http.StatusOK)
	_, _ = w.Write([]byte(shutdownResponse))
}
