package probes

import "time"

const (
	readinessOkResponse   = "ok"
	readinessFailResponse = "fail"
	shutdownResponse      = "state has been stopped"
)

func parseDelay(value string, defaultDuration time.Duration) time.Duration {
	if parsed, err := time.ParseDuration(value); err == nil {
		return parsed
	}
	return defaultDuration
}
