package probes

import (
	"net/http"

	"github.com/labstack/echo/v4"
)

type echoHandler struct {
	state  *State
	config *HTTPConfig
}

func EchoBind(config *HTTPConfig, router *echo.Echo, state *State) {
	handler := echoHandler{state: state, config: config}
	router.GET(config.ReadinessRoute, handler.readinessHandler)
	router.POST(config.ShutdownRoute, handler.shutdownHandler)
}

func (h echoHandler) readinessHandler(ctx echo.Context) error {
	if err := h.state.Ready(); err != nil {
		return ctx.String(http.StatusGone, err.Error())
	}
	return ctx.String(http.StatusOK, readinessOkResponse)
}

func (h echoHandler) shutdownHandler(ctx echo.Context) error {
	h.state.Stop(parseDelay(ctx.FormValue("delay"), h.config.ShutdownDelay))
	return ctx.String(http.StatusOK, shutdownResponse)
}
