package probes

type StateOption func(*State)

func OnReady(f func() error) StateOption {
	return func(service *State) {
		service.onReadyHooks = append(service.onReadyHooks, f)
	}
}

func OnStopBefore(f func()) StateOption {
	return func(service *State) {
		service.onStopBeforeHooks = append(service.onStopBeforeHooks, f)
	}
}

func OnStopAfter(f func()) StateOption {
	return func(service *State) {
		service.onStopAfterHooks = append(service.onStopAfterHooks, f)
	}
}
