package featureflag

import (
	"context"

	"a.yandex-team.ru/travel/library/go/containers"
)

type ctxKey struct{}

var abFlagsCtxKey = new(ctxKey)

type Flags struct {
	// Включенные флаги
	flags containers.Set[string]
	// Флаги, для которых значение "см. AB"
	abFlags containers.Set[string]
}

func NewFlags(flags containers.Set[string], abFlags containers.Set[string]) Flags {
	return Flags{flags: flags, abFlags: abFlags}
}

func (flags Flags) IsFlagEnabled(flagCode string) bool {
	return flags.flags.Contains(flagCode)
}

func (flags Flags) IsFlagEnabledWithAB(ctx context.Context, flagCode string) bool {
	if flags.useAB(flagCode) {
		ab := getABFlags(ctx)
		return ab.FlagEnabled(flagCode)
	}
	return flags.IsFlagEnabled(flagCode)
}

func (flags Flags) useAB(flagCode string) bool {
	return flags.abFlags.Contains(flagCode)
}

type abFlags struct {
	flags containers.Set[string]
}

func (ab *abFlags) FlagEnabled(flag string) bool {
	return ab.flags != nil && ab.flags.Contains(flag)
}

func WithABFlags(ctx context.Context, ab ...string) context.Context {
	return context.WithValue(ctx, &abFlagsCtxKey, abFlags{
		flags: containers.SetOf(ab...),
	})
}

func getABFlags(ctx context.Context) abFlags {
	ab, _ := ctx.Value(&abFlagsCtxKey).(abFlags)
	return ab
}

type ABFlags interface {
	FlagEnabled(string) bool
}

type ABFlagsKV map[string]string

func (abFlags ABFlagsKV) FlagEnabled(flagCode string) bool {
	val, ok := abFlags[flagCode]
	return ok && val == "1"
}

func NewABFlagsKV(flags map[string]string) ABFlags {
	if flags == nil {
		return ABFlagsKV(make(map[string]string))
	}
	return ABFlagsKV(flags)
}

func (flags Flags) IsFlagEnabledABOverride(flagCode string, abFlags ABFlags) bool {
	if flags.useAB(flagCode) {
		return abFlags.FlagEnabled(flagCode)
	}
	return flags.IsFlagEnabled(flagCode)
}
