package utils

import (
	"context"
	"encoding/json"
	"net/http"
	"net/url"
)

type httpUtils struct{}

var HTTP = httpUtils{}

type ctxKey string

const parsedQueryParametersContextKey = ctxKey("parsedQueryParameters")

func (u httpUtils) ParseQueryParameters(request *http.Request) url.Values {
	if request.Context().Value(parsedQueryParametersContextKey) == nil {
		queryParameters := request.URL.Query()
		*request = *request.WithContext(context.WithValue(request.Context(), parsedQueryParametersContextKey, queryParameters))
		return queryParameters
	}
	return request.Context().Value(parsedQueryParametersContextKey).(url.Values)
}

func (u httpUtils) JSON(writer http.ResponseWriter, code int, value interface{}) {
	writer.Header().Set("Content-Type", "application/json")
	writer.WriteHeader(code)
	_ = json.NewEncoder(writer).Encode(value)
}
