package ru.yandex.avia.booking.ff.model;

import java.util.List;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import static java.util.stream.Collectors.toList;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class FareFamilyRule {
    // term-specific values
    private TermAvailability availability;
    private ChargeValue charge;
    private String miles;
    // baggage
    private Integer places;
    private Integer weight;
    private String size;
    private String sumSize;
    // plain-text terms
    private List<LocalizedText> specialNotes;

    // matching & understanding
    private String comment;
    private String xpath;
    private String externalXpathRef;

    private Boolean ignore;

    public TermValue toTermValue(String lang, List<LocalizedText> parentSpecialNotes) {
        List<String> convertedNotes = specialNotes != null || parentSpecialNotes != null ?
                (specialNotes != null ? specialNotes : parentSpecialNotes).stream().map(note -> note.getForLang(lang)).collect(toList()) :
                null;
        return TermValue.builder()
                .availability(availability)
                .charge(charge)
                .miles(miles)
                .places(places)
                .weight(weight)
                .size(size)
                .sumSize(sumSize)
                .specialNotes(convertedNotes)
                .build();
    }
}
