package ru.yandex.avia.booking.ff.model;

import java.util.HashMap;
import java.util.Map;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.google.common.base.Strings;
import lombok.ToString;

@ToString
public class LocalizedText {
    private static final String DEFAULT_LANG = "ru";

    // lang -> value
    private Map<String, String> values = new HashMap<>();

    @JsonAnySetter
    private void setValue(String name, String value) {
        values.put(name, value);
    }

    public String getForLang(String lang) {
        String value = values.get(lang);
        if (Strings.isNullOrEmpty(value)) {
            value = values.get(DEFAULT_LANG);
        }
        if (Strings.isNullOrEmpty(value)) {
            throw new RuntimeException("Failed to convert the localized text to a string: values=" + values +
                    ", requested lang: " + lang);
        }
        return value;
    }
}
