package ru.yandex.avia.booking.ff.model;

import java.time.LocalDateTime;
import java.util.List;
import java.util.regex.Pattern;

import lombok.Builder;
import lombok.Value;

import ru.yandex.avia.booking.enums.ClassOfService;

@Value
@Builder
public class OldFareFamily {
    private String airline;
    private Pattern tariffCodePattern;
    private ClassOfService classOfService;
    private int priority;
    private LocalDateTime saleTimeSince;
    private LocalDateTime saleTimeUntil;
    private LocalDateTime flightTimeSince;
    private LocalDateTime flightTimeUntil;
    private OldFareFamilyParameter description;
    private List<OldFareFamilyParameter> fareFamilyParameters;

    public boolean isValidFor(String fareCode, LocalDateTime flightDate, LocalDateTime saleDate) {
        if (saleTimeSince != null && saleTimeUntil != null) {
            if (saleDate.isBefore(saleTimeSince) || saleDate.isAfter(saleTimeUntil)) {
                return false;
            }
        }
        if (flightTimeSince != null && flightTimeUntil != null) {
            if (flightDate.isBefore(flightTimeSince) || flightDate.isAfter(flightTimeUntil)) {
                return false;
            }
        }
        return tariffCodePattern.matcher(fareCode).matches();
    }
}
