package ru.yandex.avia.booking.service.commons;

import com.fasterxml.jackson.annotation.JsonValue;

// Here we'll collect different errors for order
public enum OrderError {
    VARIANTS_NOT_AVAILABLE("variants_not_available"),
    PRICE_CHANGED("price_changed"),
    TOKENIZATION_FAILED("tokenization_failed"),
    PAYMENT_FAILED("payment_failed");

    private String value;

    OrderError(String val) {
        value = val;
    }

    @JsonValue
    public String getValue() {
        return value;
    }

    public static OrderError fromString(String str) {
        for (OrderError candidate : OrderError.values()) {
            if (candidate.value.equalsIgnoreCase(str)) {
                return candidate;
            }
        }
        throw new IllegalArgumentException(String.format("Unknown order error type %s", str));
    }
}
