package ru.yandex.avia.booking.service.commons;

import java.text.MessageFormat;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum OrderState {
    NEW("new"),
    BOOKING("booking"),
    BOOKED("booked"),
    PROCESSING_ERROR("processing_error"),
    TICKETED("ticketed"),
    UNRECOGNIZED("unrecognized");

    private final String value;

    OrderState(String val) {
        this.value = val;
    }

    @JsonValue
    public String getValue() {
        return value;
    }

    @JsonCreator
    public static OrderState fromString(String str) {
        for (OrderState stateVal : OrderState.values()) {
            if (stateVal.getValue().equals(str)) {
                return stateVal;
            }
        }
        throw new IllegalArgumentException(
                MessageFormat.format("Can't get OrderState from string {0}", str)
        );
    }

}
