package ru.yandex.avia.booking.service.dto;

import lombok.Builder;
import lombok.Data;

import ru.yandex.travel.orders.commons.proto.EDisplayOrderState;
import ru.yandex.travel.orders.workflow.invoice.aeroflot.proto.EAeroflotInvoiceState;
import ru.yandex.travel.orders.workflow.order.aeroflot.proto.EAeroflotItemState;
import ru.yandex.travel.orders.workflow.order.aeroflot.proto.EAeroflotOrderState;

/**
 * Grpc-based states. For more info see:
 * <ul>
 *     <li>/travel/orders/proto/orders.proto</li>
 *     <li>/travel/orders/proto/provider.proto</li>
 * </ul>
 */
@Data
@Builder
public class CompositeOrderStateDTO {
    private EAeroflotOrderState orderState;
    private EAeroflotItemState serviceState;
    private EAeroflotInvoiceState invoiceState;
    private EDisplayOrderState displayOrderState;

    private String paymentUrl;
    private String confirmationUrl;
}
