package ru.yandex.avia.booking.service.dto;

import java.time.LocalDateTime;
import java.util.List;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import ru.yandex.avia.booking.ff.model.SegmentFare;
import ru.yandex.avia.booking.partners.gateways.model.search.SeatsInfo;

@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class FlightDTO {
    private String id;
    private Long from;
    private Long to;
    private Long marketingAviaCompany;
    private Long operatingAviaCompany;
    private String number;
    private LocalDateTime arrival;
    private LocalDateTime departure;
    private List<FlightStopDTO> stops;
    private SegmentFare fareTerms;
    private Integer seatsLeft;
    private SeatsInfo aircraftSeats;
}
