package ru.yandex.avia.booking.service.dto;

import java.time.LocalDateTime;
import java.util.List;
import java.util.UUID;

import lombok.Data;
import org.javamoney.moneta.Money;

import ru.yandex.avia.booking.service.commons.OrderError;
import ru.yandex.avia.booking.service.commons.OrderState;
import ru.yandex.avia.booking.service.dto.promo.AviaPromoCampaignsDTO;
import ru.yandex.avia.booking.service.dto.reference.ReferenceDTO;
import ru.yandex.travel.komod.trips.common.TripIdSetter;
import ru.yandex.travel.orders.commons.proto.EDisplayOrderState;

@Data
public class OrderDTO implements TripIdSetter {
    private String id;
    private String prettyId;
    private String partner;
    private String variantId;
    private String email;
    private String phone;
    private AirReservationDTO airReservation;
    private List<TravellerInfoDTO> travellers;
    private Money preliminaryPrice;
    private Money price;
    private OrderState state;
    private boolean stateRefreshed;
    private LocalDateTime timeLimitAt;
    private OrderError errorCode;
    private ReferenceDTO reference;
    private EDisplayOrderState eDisplayOrderState;
    private LocalDateTime servicedAt;
    private AviaPromoCampaignsDTO promoCampaigns;
    private UUID tripId;
}
