package ru.yandex.avia.booking.service.dto;

import java.time.LocalDate;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import ru.yandex.avia.booking.enums.DocumentType;
import ru.yandex.avia.booking.enums.PassengerCategory;
import ru.yandex.avia.booking.enums.Sex;

@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class TravellerInfoDTO {
    private String id;
    private String firstName;
    private String middleName;
    private String lastName;
    private Sex sex;
    private PassengerCategory category;
    private LocalDate dateOfBirth;
    private String documentNumber;
    private LocalDate documentValidTill;
    private DocumentType documentType;
    private TravellerPriceInfoDTO priceInfo;
    private String ticketNumber;
    private String loyaltyProgramInternalCode;
    private String loyaltyProgramAccountNumber;
}
