package ru.yandex.avia.booking.service.dto;

import java.util.UUID;

import lombok.NonNull;
import lombok.Value;

@Value
public class VariantCheckToken {
    public static final String TOKEN_SEPARATOR = "!";

    @NonNull
    private final UUID availabilityCheckId;
    private final String offerId;

    public VariantCheckToken(@NonNull UUID availabilityCheckId, String offerId) {
        this.availabilityCheckId = availabilityCheckId;
        this.offerId = offerId;
    }

    public static VariantCheckToken fromRaw(@NonNull String rawToken) {
        try {
            int sepIdx = rawToken.indexOf(TOKEN_SEPARATOR);
            if (sepIdx == -1) {
                return new VariantCheckToken(UUID.fromString(rawToken), null);
            } else {
                String checkId = rawToken.substring(0, sepIdx);
                String offerId = rawToken.substring(sepIdx + TOKEN_SEPARATOR.length());
                return new VariantCheckToken(UUID.fromString(checkId), offerId);
            }
        } catch (Exception e) {
            throw new IllegalArgumentException("Failed to parse the composite check token: " + rawToken);
        }
    }

    @Override
    public String toString() {
        return offerId != null ? availabilityCheckId + TOKEN_SEPARATOR + offerId : availabilityCheckId.toString();
    }
}
