package ru.yandex.avia.booking.service.dto.form;

import java.util.List;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class CreateOrderForm {

    @NotBlank
    private String variantToken;

    @NotBlank
    private String email;

    @NotBlank
    private String phone;

    // todo(tlg-13) userIp & userAgent should be made @NotBlank after RASPTICKETS-14938
    private String userIp;

    private String userAgent;

    private String marker;

    @NotEmpty
    @Valid
    private List<TravellerFormDTO> documents;

    private PromoSubscriptionRequestParams subscriptionParams;

    private String testContextToken;
    private String paymentTestContextToken;
}
