package ru.yandex.avia.booking.service.dto.form;

import java.time.LocalDate;

import javax.validation.constraints.Future;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Past;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.hibernate.validator.constraints.Length;

import ru.yandex.avia.booking.enums.DocumentType;
import ru.yandex.avia.booking.enums.Sex;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class TravellerFormDTO {
    @NotNull
    @Length(min = 1)
    private String firstName;

    private String middleName;

    @NotNull
    @Length(min = 1)
    private String lastName;

    @NotNull
    @Past
    private LocalDate dateOfBirth;

    @NotBlank
    private String documentNumber;

    @Future
    private LocalDate documentValidTill;

    @NotNull
    private DocumentType documentType;

    // transition from iso_code to geo_id, the first field should be removed later
    private String citizenship;
    private Integer citizenshipGeoId;

    //    @NotNull
    private Sex sex;

    private String loyaltyProgramInternalCode;
    private String loyaltyProgramAccountNumber;
}
