package ru.yandex.avia.booking.enums;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.AllArgsConstructor;
import lombok.Getter;

import ru.yandex.travel.commons.enums.ValueBasedEnum;
import ru.yandex.travel.commons.jackson.ValueBasedEnumDeserializationConverter;
import ru.yandex.travel.commons.jackson.ValueBasedEnumSerializationConverter;

@AllArgsConstructor
@Getter
@JsonSerialize(converter = ValueBasedEnumSerializationConverter.class)
@JsonDeserialize(converter = ClassOfService.ClassOfServiceDeserializer.class)
public enum ClassOfService implements ValueBasedEnum<String> {
    ECONOMY("economy"),
    BUSINESS("business"),
    FIRST("first"),
    PREMIUM_ECONOMY("premium_economy"),
    OTHER("other");

    private final String value;

    static class ClassOfServiceDeserializer extends ValueBasedEnumDeserializationConverter<String, ClassOfService> {
        @Override
        public ClassOfService convert(String value) {
            // the old implementation didn't use separate string constants and the values were stored in upper case
            return super.convert(value != null ? value.toLowerCase() : null);
        }
    }
}
