package ru.yandex.avia.booking.enums;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.AllArgsConstructor;
import lombok.Getter;

import ru.yandex.travel.commons.enums.ValueBasedEnum;
import ru.yandex.travel.commons.jackson.ValueBasedEnumDeserializationConverter;
import ru.yandex.travel.commons.jackson.ValueBasedEnumSerializationConverter;

@AllArgsConstructor
@Getter
@JsonSerialize(converter = ValueBasedEnumSerializationConverter.class)
@JsonDeserialize(converter = DocumentType.DocumentTypeDeserializer.class)
public enum DocumentType implements ValueBasedEnum<String> {
    PASSPORT("passport"),
    INTERNATIONAL_PASSPORT_RU("international_passport_ru"),
    BIRTH_CERTIFICATE("birth_certificate"),
    NATIONAL_PASSPORT("national_passport");

    private final String value;

    static class DocumentTypeDeserializer extends ValueBasedEnumDeserializationConverter<String, DocumentType> {
    }
}
