package ru.yandex.avia.booking.enums;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.AllArgsConstructor;
import lombok.Getter;

import ru.yandex.travel.commons.enums.ValueBasedEnum;
import ru.yandex.travel.commons.jackson.ValueBasedEnumDeserializationConverter;
import ru.yandex.travel.commons.jackson.ValueBasedEnumSerializationConverter;

@AllArgsConstructor
@Getter
@JsonSerialize(converter = ValueBasedEnumSerializationConverter.class)
@JsonDeserialize(converter = PassengerCategory.PassengerCategoryDeserializer.class)
public enum PassengerCategory implements ValueBasedEnum<String> {
    ADULT("adult"),
    CHILD("child"),
    INFANT("infant");

    private final String value;

    static class PassengerCategoryDeserializer
            extends ValueBasedEnumDeserializationConverter<String, PassengerCategory> {
    }
}
