package ru.yandex.avia.booking.enums;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.AllArgsConstructor;
import lombok.Getter;

import ru.yandex.travel.commons.enums.ValueBasedEnum;
import ru.yandex.travel.commons.jackson.ValueBasedEnumDeserializationConverter;
import ru.yandex.travel.commons.jackson.ValueBasedEnumSerializationConverter;

@AllArgsConstructor
@Getter
@JsonSerialize(converter = ValueBasedEnumSerializationConverter.class)
@JsonDeserialize(converter = RefundableStatus.RefundableStatusDeserializer.class)
public enum RefundableStatus implements ValueBasedEnum<String> {
    REFUNDABLE("refundable"),
    NON_REFUNDABLE("non_refundable"),
    UNKNOWN("unknown"),
    PENALTIES_APPLY("penalties_apply");

    private final String value;

    static class RefundableStatusDeserializer extends ValueBasedEnumDeserializationConverter<String, RefundableStatus> {
    }
}
