package ru.yandex.avia.booking.enums;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.AllArgsConstructor;
import lombok.Getter;

import ru.yandex.travel.commons.enums.ValueBasedEnum;
import ru.yandex.travel.commons.jackson.ValueBasedEnumDeserializationConverter;
import ru.yandex.travel.commons.jackson.ValueBasedEnumSerializationConverter;

@AllArgsConstructor
@Getter
@JsonSerialize(converter = ValueBasedEnumSerializationConverter.class)
@JsonDeserialize(converter = Sex.SexDeserializer.class)
public enum Sex implements ValueBasedEnum<String> {
    MALE("male"),
    FEMALE("female");

    private final String value;

    static class SexDeserializer extends ValueBasedEnumDeserializationConverter<String, Sex> {
    }
}
