package ru.yandex.avia.booking.partners.gateways;

import com.fasterxml.jackson.databind.JsonNode;

import ru.yandex.avia.booking.partners.gateways.model.availability.AvailabilityCheckRequest;
import ru.yandex.avia.booking.partners.gateways.model.availability.AvailabilityCheckResponse;
import ru.yandex.avia.booking.partners.gateways.model.availability.VariantNotAvailableException;
import ru.yandex.avia.booking.partners.gateways.model.booking.ServicePayload;
import ru.yandex.avia.booking.partners.gateways.model.booking.ServicePayloadInitParams;
import ru.yandex.avia.booking.partners.gateways.model.search.Variant;

public interface BookingGateway {
    AvailabilityCheckResponse checkAvailabilityAll(AvailabilityCheckRequest request) throws VariantNotAvailableException;

    Object resolveVariantInfo(JsonNode node);

    Object resolveVariantInfoAndOptimizeJson(JsonNode node);

    void synchronizeUpdatedVariantInfoJson(JsonNode node, Variant variantInfo);

    String getExternalVariantId(Object variantInfo);

    ServicePayload createServicePayload(ServicePayloadInitParams params);

    Class<? extends ServicePayload> getPayloadType();
}
