package ru.yandex.avia.booking.partners.gateways.aeroflot;

import java.time.Clock;
import java.time.Instant;
import java.util.Map;
import java.util.TreeMap;

import lombok.Getter;
import lombok.RequiredArgsConstructor;

@Getter
public class AeroflotDynamicPropertiesProvider {
    private final DynamicProperty aggregatorId;
    private final DynamicProperty authToken;

    public AeroflotDynamicPropertiesProvider(Clock clock) {
        aggregatorId = new DynamicProperty(clock);
        authToken = new DynamicProperty(clock);
    }

    @RequiredArgsConstructor
    public static class DynamicProperty {
        private final Clock clock;
        private final TreeMap<Instant, String> scheduledValues = new TreeMap<>();

        public String getValue() {
            Map.Entry<Instant, String> entry = scheduledValues.floorEntry(Instant.now(clock));
            if (entry == null) {
                throw new IllegalStateException("The property hasn't been initialised properly. " +
                        "Supported activation timestamps are " + scheduledValues.keySet());
            }
            return entry.getValue();
        }

        public void setValue(String value) {
            setValue(value, Instant.MIN);
        }

        public void setValue(String value, Instant activatesAt) {
            scheduledValues.put(activatesAt, value);
        }
    }
}
