package ru.yandex.avia.booking.partners.gateways.aeroflot;

import lombok.Getter;
import lombok.RequiredArgsConstructor;

import ru.yandex.travel.commons.enums.EnumIndex;
import ru.yandex.travel.commons.enums.ValueBasedEnum;

@RequiredArgsConstructor
@Getter
public enum AeroflotNdcApiCustomErrorCode implements ValueBasedEnum<String> {
    // Тариф не соответствует классу бронирования
    SABRE_NO_FARE_FOR_CLASS("SabreNoFareForClassException"),
    // Дата вылета меньше допустимого значения: 2020-10-29 02:35:00+03:00
    DEPARTURE_IS_TOO_CLOSE("SegmentDepartureIsTooCloseValidateException"),
    // Не найден рейс для указанной авиакомпании или даты
    SABRE_NO_SUCH_FLIGHT("SabreFlightNoOpException"),

    // syntactic sugar: safe null analogue for all unknown values
    UNKNOWN_ERROR("<UNKNOWN>");

    private final String value;

    private static final EnumIndex<String, AeroflotNdcApiCustomErrorCode> index =
            EnumIndex.create(AeroflotNdcApiCustomErrorCode.class);

    public static AeroflotNdcApiCustomErrorCode getByValue(String value) {
        return index.getByValueOrDefault(value, UNKNOWN_ERROR);
    }
}
