package ru.yandex.avia.booking.partners.gateways.aeroflot;

import java.util.Map;
import java.util.stream.Stream;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import lombok.AllArgsConstructor;
import lombok.Getter;

import static java.util.stream.Collectors.toMap;

@AllArgsConstructor
@Getter
public enum AeroflotNdcApiPaymentErrorCode {

    // <Remark>Необходима авторизация по 3D Secure / Secure Code</Remark>
    PAYMENT_3DS_REQUIRED("3"),

    // <Remark>Отказ в проведении оплаты</Remark>
    PAYMENT_REJECTED("2"),
    // <Remark>Отказ в проведении оплаты. Оплата заказа невозможна</Remark>
    PAYMENT_REJECTED_IMPOSSIBLE("7"),

    // <Remark>Оплата выполнена, но билеты не выпущены : ru bpc phoenix integration sabre TicketIssueException Could not send Message</Remark>
    TICKETS_NOT_ISSUED("-21"),

    // <Remark>Некорректный или устаревший токен</Remark>
    INVALID_TOKEN("-26"),

    // other known codes: 0=Not paid, -5=Unavailable

    // for all not mapped codes
    UNKNOWN("<unknown>");


    private static final Map<String, AeroflotNdcApiPaymentErrorCode> codeIndex = ImmutableMap.copyOf(
            Stream.of(AeroflotNdcApiPaymentErrorCode.values()).collect(toMap(AeroflotNdcApiPaymentErrorCode::getCode, e -> e))
    );

    private final String code;

    public static AeroflotNdcApiPaymentErrorCode getCode(String value) {
        return !Strings.isNullOrEmpty(value) ? codeIndex.getOrDefault(value, UNKNOWN) : null;
    }
}
