package ru.yandex.avia.booking.partners.gateways.aeroflot;

import java.time.Duration;
import java.time.Instant;

import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class AeroflotProviderProperties {
    // http client
    @NotEmpty
    private String authToken;
    @NotEmpty
    private String contentType;

    // gateway settings
    private String searchUrl;
    @NotEmpty
    private String bookingUrl;
    @NotEmpty
    private String userName;
    @NotEmpty
    private String userAgent;
    @NotNull
    private Duration readTimeout;

    private boolean enableTestingScenarios;

    private String seatsInfoCacheSpec;

    @Valid
    @NotNull
    private WhiteMonday2020Promo promo2020;

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class WhiteMonday2020Promo {
        @NotNull
        private Boolean enabled;
        @NotNull
        private Instant startsAt;
        @NotNull
        private Instant endsAt;
        @NotEmpty
        private String userName;
        @NotEmpty
        private String authToken;
    }
}
