package ru.yandex.avia.booking.partners.gateways.aeroflot.converter;

import com.google.common.collect.ImmutableBiMap;
import lombok.NonNull;

import ru.yandex.avia.booking.enums.ClassOfService;
import ru.yandex.avia.booking.enums.PassengerCategory;
import ru.yandex.avia.booking.enums.Sex;

/*
* Temporary code mappings for parameters from TD, need to apply the mapping part on the TD side.
* See aeroflot.py
**/
public class AeroflotCodesMapping {
    public static ImmutableBiMap<ClassOfService, Integer> CLASS_TO_CODE = ImmutableBiMap.of(
            ClassOfService.ECONOMY, 3,
            ClassOfService.BUSINESS, 2,
            ClassOfService.PREMIUM_ECONOMY, 4);

    public static ImmutableBiMap<String, String> NATIONAL_VERSION_TO_CODE = ImmutableBiMap.of(
            "ru", "RU",
            "ua", "UA",
            "kz", "KZ",
            "tr", "TR",
            "com", "GB"
    );

    public static ImmutableBiMap<PassengerCategory, String> CATEGORY_TO_CODE = ImmutableBiMap.of(
            PassengerCategory.ADULT, "ADT",
            PassengerCategory.CHILD, "CHD",
            PassengerCategory.INFANT, "INF");

    public static ImmutableBiMap<Sex, String> SEX_TO_CODE = ImmutableBiMap.of(
            Sex.MALE, "Male",
            Sex.FEMALE, "Female");

    @NonNull
    public static String countryCode(@NonNull String nationalVersion) {
        return NATIONAL_VERSION_TO_CODE.getOrDefault(nationalVersion, nationalVersion.toUpperCase());
    }

    @NonNull
    public static PassengerCategory categoryEnum(@NonNull String code) {
        if (CATEGORY_TO_CODE.inverse().containsKey(code)) {
            return CATEGORY_TO_CODE.inverse().get(code);
        }
        throw new IllegalArgumentException("Unknown passenger category: " + code);
    }

    @NonNull
    public static String categoryCode(@NonNull PassengerCategory category) {
        if (CATEGORY_TO_CODE.containsKey(category)) {
            return CATEGORY_TO_CODE.get(category);
        }
        throw new IllegalArgumentException("The passenger category isn't mapped to a code: " + category);
    }

    @NonNull
    public static ClassOfService classOfServiceEnum(int cabinType) {
        return CLASS_TO_CODE.inverse().getOrDefault(cabinType, ClassOfService.OTHER);
    }
}
