package ru.yandex.avia.booking.partners.gateways.aeroflot.model;

import java.util.List;
import java.util.NoSuchElementException;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.NonNull;
import lombok.experimental.Accessors;

@Data
@Builder(toBuilder = true)
@Accessors(chain = true)
@NoArgsConstructor // json support
@AllArgsConstructor
public class AeroflotCategoryOffer implements AeroflotEntity {
    //@NonNull
    private String id;
    //@NonNull
    private String travellerId;
    //@NonNull
    private AeroflotPriceDetail totalPrice;
    //@NonNull
    private List<AeroflotSegmentFareCode> fareBasisCodes;

    @NonNull
    public String getFareBasisCode(@NonNull String segmentId) {
        for (AeroflotSegmentFareCode fareBasisCode : fareBasisCodes) {
            if (fareBasisCode.getSegmentId().equals(segmentId)) {
                return fareBasisCode.getFareCode();
            }
        }
        throw new NoSuchElementException(String.format("missing fare basis code: segment_id=%s, offer=%s", segmentId, this));
    }
}
