package ru.yandex.avia.booking.partners.gateways.aeroflot.model;

import java.util.List;
import java.util.Map;

import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.NonNull;
import lombok.experimental.Accessors;

import static ru.yandex.avia.booking.partners.gateways.aeroflot.model.AeroflotOrderStatus.PAID_TICKETED;
import static ru.yandex.avia.booking.partners.gateways.aeroflot.model.AeroflotOrderStatus.PAYMENT_FAILED;
import static ru.yandex.avia.booking.partners.gateways.aeroflot.model.AeroflotOrderStatus.PAYMENT_PARTIALLY_FAILED;
import static ru.yandex.avia.booking.partners.gateways.aeroflot.model.AeroflotOrderSubStatus.PAYMENT_EXPIRED;
import static ru.yandex.avia.booking.partners.gateways.aeroflot.model.AeroflotOrderSubStatus.PAYMENT_EXPIRED_2;
import static ru.yandex.avia.booking.partners.gateways.aeroflot.model.AeroflotOrderSubStatus.REQUIRES_3DS;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@Accessors(chain = true)
public class AeroflotOrderCreateResult {
    @NonNull
    private AeroflotOrderStatus statusCode;
    @Nullable
    private AeroflotOrderSubStatus subStatusCode;
    @Nullable
    private Map<String, List<AeroflotTicketCoupon>> couponStatusCodes;
    @NonNull
    private AeroflotOrderRef orderRef;
    //@NonNull
    private String confirmationUrl;

    @JsonIgnore
    public boolean isPaid() {
        if (statusCode == AeroflotOrderStatus.PAID_NOT_TICKETED) {
            return true;
        }
        return statusCode == PAID_TICKETED;
    }

    @JsonIgnore
    public boolean isExpired() {
        // todo(tlg-13): rm temporary backward compatibility
        if (statusCode == AeroflotOrderStatus.PAYMENT_TIMED_OUT) {
            return true;
        }
        return statusCode == PAYMENT_FAILED
                && (subStatusCode == PAYMENT_EXPIRED || subStatusCode == PAYMENT_EXPIRED_2);
    }

    @JsonIgnore
    public boolean is3dsRequired() {
        // todo(tlg-13): rm temporary backward compatibility
        if (statusCode == AeroflotOrderStatus.PAYMENT_3DS_NEEDED) {
            return true;
        }
        return statusCode == PAYMENT_PARTIALLY_FAILED
                && subStatusCode == REQUIRES_3DS;
    }
}

