package ru.yandex.avia.booking.partners.gateways.aeroflot.model;

import lombok.AllArgsConstructor;
import lombok.Getter;

import ru.yandex.travel.commons.enums.MultiEnumIndex;
import ru.yandex.travel.commons.enums.ValueBasedEnum;

/**
 * More info on the updated statuses can be found in the latest specification
 * or in https://jira.aeroflot.ru/browse/NDCYAN-30.
 */
@Getter
@AllArgsConstructor
public enum AeroflotOrderStatus implements ValueBasedEnum<String> {
    PAID_TICKETED("10"),
    // deleted; returned as 60 + 630
    @Deprecated
    PAYMENT_3DS_NEEDED("30"),
    // deleted; returned as 10 + 150
    @Deprecated
    PAID_NOT_TICKETED("40"),
    PAYMENT_FAILED("50"),
    PAYMENT_PARTIALLY_FAILED("60"),
    PAYMENT_STATUS_UNKNOWN("70"),
    // deleted; returned as 50 + 590; actual meaning of this status is "CANCELLED"
    @Deprecated
    PAYMENT_TIMED_OUT("80");

    private final String value;

    public static AeroflotOrderStatus forValue(String value) {
        return MultiEnumIndex.getGlobal().get(AeroflotOrderStatus.class).getByValue(value);
    }
}
