package ru.yandex.avia.booking.partners.gateways.aeroflot.model;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.NonNull;
import lombok.experimental.Accessors;

@Data
@Builder
@Accessors(chain = true)
@NoArgsConstructor // json support
@AllArgsConstructor
public class AeroflotSegment implements AeroflotEntity {
    @NonNull
    private String id;
    @NonNull
    private String originDestinationId;
    @NonNull
    private AeroflotSegmentNode departure;
    @NonNull
    private AeroflotSegmentNode arrival;
    @NonNull
    private AeroflotCarrier marketingCarrier;
    @NonNull
    private AeroflotCarrier operatingCarrier;
    @NonNull
    private String aircraftCode;
    @NonNull
    private String flightDuration;

    // v3 model extension
    private String journeyId;
    private String segmentTypeCode;
}
