package ru.yandex.avia.booking.partners.gateways.aeroflot.model;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;

import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.NonNull;
import lombok.experimental.Accessors;

@Data
@Builder
@Accessors(chain = true)
@NoArgsConstructor // json support
@AllArgsConstructor
public class AeroflotSegmentNode {
    public static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");

    @NonNull
    private String airportCode;
    @NonNull
    private String date;
    @NonNull
    private String time;

    @JsonIgnore
    public LocalDateTime getDateTime() {
        return LocalDate.parse(date).atTime(LocalTime.parse(time));
    }
}
